<?php

/**
 * 获取亲密关系申请
 */

namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGIntimacyApplyInfo;
use Game\Protobuf\GCIntimacyApplyInfo;
use Game\Protobuf\PacketId;

class CG_IntimacyApplyInfo extends ControllerBase
{
    use FriendLogic;

    private GCIntimacyApplyInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGIntimacyApplyInfo();
        $this->sendMessage = new GCIntimacyApplyInfo();
    }

    public function run(): int
    {
        [$info, $maxPage] = $this->getMyIntimacyApplyInfo($this->message->getPage());
        $this->sendMessage->setInfo($info);
        $this->sendMessage->setMaxPage($maxPage);
        $this->sendMessage->setPage($this->message->getPage());
        SendMessage::getInstance()->sendClient(PacketId::GC_IntimacyApplyInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
