<?php

/**
 * 申请亲密关系
 */

namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGIntimacyApply;
use Game\Protobuf\GCIntimacyApply;
use Game\Protobuf\PacketId;

class CG_IntimacyApply extends ControllerBase
{
    use FriendLogic;

    private GCIntimacyApply $sendMessage;

    public function __construct()
    {
        $this->message = new CGIntimacyApply();
        $this->sendMessage = new GCIntimacyApply();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->applyIntimacy(
                $this->playerId,
                $this->message->getPlayerId(),
                $this->message->getIntimacyId()
            )
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_IntimacyApply, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
