<?php

/**
 * 行驶证-车辆使用次数
 */

namespace Game\Controller\DrivingPermit;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ModelTypeDefine;
use Game\Data\AccountData;
use Game\Logic\PVE\DrivingPermitLogic;
use Game\Model\AccountModel;
use Game\Protobuf\CGDrivingPermit;
use Game\Protobuf\GCDrivingPermit;
use Game\Protobuf\PacketId;

class CG_DrivingPermit extends ControllerBase
{
    use DrivingPermitLogic;

    private GCDrivingPermit $sendMessage;

    public function __construct()
    {
        $this->message = new CGDrivingPermit();
        $this->sendMessage = new GCDrivingPermit();
    }

    public function run(): int
    {
        $carUseNumRace = 0;
        $carUseNumJam = 0;
        $carUseNumHelp = 0;
        /**
         * @var AccountModel $accountModel
         */
        $accountModel = ModelManager::getInstance()->getModel(ModelTypeDefine::ACCOUNT);
        $playerInfo = array();
        $arr = array(
            AccountData::DB_CAR_USE_NUM_RACE,
            AccountData::DB_CAR_USE_NUM_JAM,
            AccountData::DB_CAR_USE_NUM_HELP
        );
        if ($accountModel->search($this->playerId, $playerInfo)) {
            $tmp = array();
            foreach ($arr as $idx => $key) {
                $tmp[$idx] = isset($playerInfo[$key]) ? intval($playerInfo[$key]) : 0;
            }
            $carUseNumRace = $tmp[0];
            $carUseNumJam = $tmp[1];
            $carUseNumHelp = $tmp[2];
        }
        $this->sendMessage->setCarUseNumRace($carUseNumRace);
        $this->sendMessage->setCarUseNumJam($carUseNumJam);
        $this->sendMessage->setCarUseNumHelp($carUseNumHelp);
        $this->sendMessage->setGroup($this->getCarGroup());
        SendMessage::getInstance()->sendClient(PacketId::GC_DrivingPermit, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
