<?php

/**
 * 获取驾照关卡
 */

namespace Game\Controller\DrivingLicense;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\ModelTypeDefine;
use Game\Logic\PVE\DrivingLicenseLogic;
use Game\Model\PVE\PveModel;
use Game\Protobuf\CGDrivingLicenseChapter;
use Game\Protobuf\GCDrivingLicenseChapter;
use Game\Protobuf\PacketId;

class CG_DrivingLicenseChapter extends ControllerBase
{
    use DrivingLicenseLogic;

    private GCDrivingLicenseChapter $sendMessage;

    public function __construct()
    {
        $this->message = new CGDrivingLicenseChapter();
        $this->sendMessage = new GCDrivingLicenseChapter();
    }

    public function run(): int
    {
        $chapterId = $this->message->getDrivingLicenseLv();
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $lv = $pveModel->getDrivingLicenseLv();
        //检查是否解锁
        if ($chapterId > $lv + 1) {
            return $this->sendUnlockChapterMessage();
        }
        if ($chapterId == 0) {
            //返回C级关卡
            $chapterId = TemplateTale::DRIVING_LICENSE_LEVEL_C;
        }
        //发送消息
        $this->sendChapterLevelMessage($chapterId);
        return ErrorDefine::SUCCESS;
    }

    //未解锁章节消息
    private function sendUnlockChapterMessage(): int
    {
        $this->sendMessage->setLevel(array());
        SendMessage::getInstance()->sendClient(PacketId::GC_DrivingLicenseChapter, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
