<?php

/**
 * desc 模糊查询俱乐部
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGSearchClubFuzzy;

class SearchClubFuzzy extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGSearchClubFuzzy();
    }

    public function run(): int {
        $search = trim($this->message->getSearch());

        if(!$this->searchClubByCondition($search)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}