<?php

/**
 * desc 请求加入俱乐部
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGRequestJoinClub;

class RequestJoin extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGRequestJoinClub();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        if(!$this->requestJoinClub($clubID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}