<?php

/**
 * desc 更换队长
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGReplaceClubMaster;

class ReplaceMaster extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGReplaceClubMaster();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        $playerID = $this->message->getPlayerID();
        $serverID = $this->message->getServerID();

        if(!$this->replaceClubMaster($clubID, $playerID, $serverID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}