<?php
/**
 * 随机搜索俱乐部
 * @date 2022/7/1
 * @author JZW
 **/

namespace Game\Controller\Club;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGRandSearchClub;
use Game\Protobuf\GCRandSearchClub;
use Game\Protobuf\PacketId;

class RandomSearch extends ControllerBase
{
    use ClubLogic;
    public GCRandSearchClub $sendMessage;

    public function __construct()
    {
        $this->message = new CGRandSearchClub();
        $this->sendMessage = new GCRandSearchClub();
    }

    public function run(): int
    {
        $List = $this->randomClubList();
        $Info = $this->sendClientData($List);
        $this->sendMessage->setData($Info);
        SendMessage::getInstance()->sendClient(PacketId::GC_RandSearchClub, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}