<?php

/**
 * desc 发起弹劾队长
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGImpeachMaster;

class ImpeachMaster extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGImpeachMaster();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        $serverID = $this->message->getServerID();

        if(!$this->impeachMaster($clubID, $serverID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}