<?php

/**
 * desc 获取俱乐部列表
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomLogic;
use Game\Protobuf\CGCreateRoom;

class GetClubList extends ControllerBase {

    use RoomLogic;
    public function __construct() {
        $this->message = new CGCreateRoom();
    }

    public function run(): int {
        $mapID = $this->message->getMapID();
        $modeType = $this->message->getModeType();

        if(!$this->createRoom($mapID, $modeType)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}