<?php

/**
 * desc 获取俱乐部信息
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGClubInfo;

class GetClubInfo extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGClubInfo();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();

        if(!$this->getClubInfo($clubID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}