<?php
/**
 * 获取俱乐部战令数据
 * @date 2022/7/22/022
 * @author JZW
 **/

namespace Game\Controller\Club;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGGetClubBattlePass;
use Game\Protobuf\GCGetClubBattlePass;
use Game\Protobuf\PacketId;

class GetBattlePass extends ControllerBase
{
    use ClubLogic;


    public GCGetClubBattlePass $sendMessage;
    public function __construct()
    {
        $this->message = new CGGetClubBattlePass();
        $this->sendMessage = new GCGetClubBattlePass();
    }

    public function run(): int
    {
        $data = $this->getBattlePass($code);
        $active = $this->getBattlePassActive();
        $this->sendMessage->setCode($code);
        $this->sendMessage->setActive($active);
        $this->sendMessage->setData($data);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetClubBattlePass, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}