<?php

/**
 * desc 解散俱乐部
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGDisbandClub;

class DisbandClub extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGDisbandClub();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();

        if(!$this->disbandClub($clubID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}