<?php

/**
 * desc 删除俱乐部成员
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGDelClubMember;

class DelClubMember extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGDelClubMember();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        $playerID = $this->message->getPlayerID();
        $serverID = $this->message->getServerID();

        if(!$this->delClubMember($clubID, $playerID, $serverID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}