<?php

/**
 * desc 新建俱乐部
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGCreateClub;

class CreateClub extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGCreateClub();
    }

    public function run(): int {
        $image = $this->message->getImage();
        $bgImage = $this->message->getBgImage();
        $name = trim($this->message->getClubName());
        $sub = $this->message->getMoney();
        $subMoney = [];
        foreach ($sub as $item) {
            $type = $item->getType();
            $num = $item->getNum();
            $subMoney[$type] = $num;
        }

        if(!$this->createClub($image, $bgImage, $name, $subMoney)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}