<?php

/**
 * desc 修改俱乐部标签
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGChangeTag;

class ChangeTag extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGChangeTag();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        $tags = $this->message->getTag();
        $tag = [];
        foreach ($tags as $item) {
            array_push($tag, $item);
        }

        if(!$this->changeTag($clubID, $tag)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}