<?php

/**
 * desc 升降职位
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGChangePost;

class ChangePost extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGChangePost();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        $playerID = $this->message->getPlayerID();
        $post = $this->message->getPost();
        $serverID = $this->message->getServerID();

        if(!$this->changePlayerPost($clubID, $playerID, $post, $serverID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}