<?php

/**
 * desc 修改俱乐部宣言
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGChangeNotice;

class ChangeNotice extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGChangeNotice();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        $notice = $this->message->getNotice();

        if(!$this->changeClubNotice($clubID, $notice)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}