<?php

/**
 * desc 修改俱乐部配置
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGChangeClub;

class ChangeClub extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGChangeClub();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        $type = $this->message->getType();
        $params = $this->message->getParam();

        if(!$this->changeClub($clubID, $type, $params)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}