<?php

/**
 * 每日捐献
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGDailyDonate;
use Game\Protobuf\GCDailyDonate;
use Game\Protobuf\PacketId;

class CG_DailyDonate extends ControllerBase
{
    use ClubLogic;

    private GCDailyDonate $sendMessage;

    public function __construct()
    {
        $this->message = new CGDailyDonate();
        $this->sendMessage = new GCDailyDonate();
    }

    public function run(): int
    {
        [$code, $active, $flag] = $this->dailyDonate();
        $this->sendMessage->setCode($code);
        $this->sendMessage->setActive($active);
        $this->sendMessage->setDailyDonateFlag($flag);
        SendMessage::getInstance()->sendClient(PacketId::GC_DailyDonate, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
