<?php

/**
 * desc 购买俱乐部商品
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubStoreLogic;
use Game\Protobuf\CGBuyClubStoreItem;

class BuyStoreItem extends ControllerBase {

    use ClubStoreLogic;
    public function __construct() {
        $this->message = new CGBuyClubStoreItem();
    }

    public function run(): int {
        $id = $this->message->getID();
        $num = $this->message->getNum();

        if(!$this->buyClubStoreItem($id, $num)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}