<?php
/**
 * 领取俱乐部战令奖励
 * @date 2022/7/25
 * @author JZW
 **/

namespace Game\Controller\Club;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGClubBattlePassReward;
use Game\Protobuf\GCClubBattlePassReward;
use Game\Protobuf\PacketId;

class BattlePassReward extends ControllerBase
{
    use ClubLogic;

    public GCClubBattlePassReward $sendMessage;

    public function __construct()
    {
        $this->message = new CGClubBattlePassReward();
        $this->sendMessage = new GCClubBattlePassReward();
    }

    public function run(): int
    {
        $type = $this->message->getType();
        $rewardId = $this->message->getBattlePassId();
        $code = $this->getClubBattlePassReward($type, $rewardId);
        $this->sendMessage->setCode($code);
        $this->sendMessage->setBattlePassId($rewardId);
        SendMessage::getInstance()->sendClient(PacketId::GC_ClubBattlePassReward, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}