<?php
/**
 * Battle pass 活跃度兑换代币
 * @date 2022/7/29/029
 * @author JZW
 **/

namespace Game\Controller\Club;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGGetClubBattlePassMoney;
use Game\Protobuf\GCGetClubBattlePassMoney;
use Game\Protobuf\PacketId;

class BattlePassMoney extends ControllerBase
{
    use ClubLogic;
    public GCGetClubBattlePassMoney $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetClubBattlePassMoney();
        $this->sendMessage = new GCGetClubBattlePassMoney();
    }

    public function run(): int
    {
        $this->getBattlePassClubMoney($code);
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetClubBattlePassMoney, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}