<?php

/**
 * desc 加入审核
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGApprovalJoin;

class ApprovalJoin extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGApprovalJoin();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();
        $playerID = $this->message->getPlayerID();
        $pass = $this->message->getPass();
        $name = $this->message->getClubName();
        $serverID = $this->message->getServerID();

        if(!$this->approvalJoin($clubID, $playerID, $pass, $name, $serverID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}