<?php

/**
 * desc 清空请求加入列表
 */

namespace Game\Controller\Club;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGApplyJoinClear;

class ApplyJoinClear extends ControllerBase {

    use ClubLogic;
    public function __construct() {
        $this->message = new CGApplyJoinClear();
    }

    public function run(): int {
        $clubID = $this->message->getClubID();

        if(!$this->clearApplyJoinList($clubID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}