<?php

/**
 * 章节奖励,按星星的总数来领取奖励
 **/

namespace Game\Controller\Career;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\PVE\CareerLogic;
use Game\Protobuf\CGGameLevelStarReward;
use Game\Protobuf\GCGameLevelStarReward;
use Game\Protobuf\PacketId;

class CG_GameLevelStarReward extends ControllerBase
{
    use CareerLogic;

    private GCGameLevelStarReward $sendMessage;

    public function __construct()
    {
        $this->message = new CGGameLevelStarReward();
        $this->sendMessage = new GCGameLevelStarReward();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->getCareerStarReward(
                $this->message->getChapterId(),
                $this->message->getId()
            )
        );
        $this->sendMessage->setInfo(
            $this->getStarRewardMessage(
                $this->message->getChapterId()
            )
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_GameLevelStarReward, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
