<?php

/**
 * 获取星级宝箱
 **/

namespace Game\Controller\Career;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\PVE\CareerLogic;
use Game\Protobuf\CGGameLevelStarData;
use Game\Protobuf\GCGameLevelStarData;
use Game\Protobuf\PacketId;

class CG_GameLevelStarData extends ControllerBase
{
    use CareerLogic;

    private GCGameLevelStarData $sendMessage;

    public function __construct()
    {
        $this->message = new CGGameLevelStarData();
        $this->sendMessage = new GCGameLevelStarData();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setInfo(
            $this->getStarRewardMessage(
                $this->message->getChapterId()
            )
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_GameLevelStarData, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
