<?php

/**
 * 获取生涯关卡数据
 */

namespace Game\Controller\Career;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Data\PVE\CareerLevelData;
use Game\Logic\PVE\CareerLogic;
use Game\Protobuf\CGGameLevelData;
use Game\Protobuf\GameLevel;
use Game\Protobuf\GCGameLevelData;
use Game\Protobuf\PacketId;

class CG_GameLevelData extends ControllerBase
{
    use CareerLogic;

    private GCGameLevelData $sendMessage;

    public function __construct()
    {
        $this->message = new CGGameLevelData();
        $this->sendMessage = new GCGameLevelData();
    }

    public function run(): int
    {
        $data = $this->getAllCareerLevels(
            $this->message->getChapterId()
        );
        $ret = [];
        foreach ($data as $careerLevelData) {
            /**
             * @var CareerLevelData $careerLevelData
             */
            $gameLevel = new GameLevel();
            $gameLevel->setLevelId($careerLevelData->levelId);
            $gameLevel->setLevelStar($careerLevelData->starNum);
            $gameLevel->setLevelStatus($careerLevelData->status);
            $gameLevel->setBestTime($careerLevelData->bestTime);
            $target = array(
                $careerLevelData->target1Status,
                $careerLevelData->target2Status,
                $careerLevelData->target3Status,
            );
            $gameLevel->setTarget(implode("-", $target));
            $ret[] = $gameLevel;
        }
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setInfo($ret);
        SendMessage::getInstance()->sendClient(PacketId::GC_GameLevelData, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
