<?php

/**
 * 获取已解锁的最大章节
 */

namespace Game\Controller\Career;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ModelTypeDefine;
use Game\Model\PVE\PveModel;
use Game\Protobuf\CGGameLevelChapter;
use Game\Protobuf\ChapterStarData;
use Game\Protobuf\GCGameLevelChapter;
use Game\Protobuf\PacketId;

class CG_GameLevelChapter extends ControllerBase
{
    private GCGameLevelChapter $sendMessage;

    public function __construct()
    {
        $this->message = new CGGameLevelChapter();
        $this->sendMessage = new GCGameLevelChapter();
    }

    public function run(): int
    {
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $chapterId = $pveModel->getChapterId();
        $this->sendMessage->setChapterId($chapterId);
        $starData = array();
        for ($i = 1; $i <= $chapterId; $i++) {
            $chapterStar = new ChapterStarData();
            $chapterStar->setChapterId($i);
            $chapterStar->setStarNum($pveModel->getAllStarNum($i));
            $starData[] = $chapterStar;
        }
        $this->sendMessage->setChapterStar($starData);
        SendMessage::getInstance()->sendClient(PacketId::GC_GameLevelChapter, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
