<?php

/**
 * UpGrade.php
 * 升级赛车
 * Created On 2022/03/11
 */

namespace Game\Controller\Car;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\CarLogic;
use Game\Protobuf\CGUpGradeCarSend;
use Game\Protobuf\GCUpGradeCarRecv;
use Game\Protobuf\PacketId;

class UpGrade extends ControllerBase
{
    use CarLogic;

    public GCUpGradeCarRecv $sendMessage;

    public function __construct()
    {
        $this->message = new CGUpGradeCarSend();
        $this->sendMessage = new GCUpGradeCarRecv();
    }

    public function run(): int
    {
        $uid = $this->message->getUid();
        $tpl1 = $this->message->getUseTplID1();
        $num1 = $this->message->getNum1();
        $tpl2 = $this->message->getUseTplID2();
        $num2 = $this->message->getNum2();
        $code = $this->upGrade($uid, $tpl1, $num1, $tpl2, $num2);
        $this->sendMessage->setCode($code);
        $this->sendMessage->setUid($uid);
        SendMessage::getInstance()->sendClient(PacketId::GC_Car_Up_Grade_Recv, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}