<?php
/**
 *
 * @date 2022-3-23
 * @author JZW
 **/


namespace Game\Controller\Car;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\CarLogic;
use Game\Protobuf\CGSearchRefit;
use Game\Protobuf\GCReplySearchRefitData;
use Game\Protobuf\PacketId;

class SearchRefitData  extends ControllerBase
{
    use CarLogic;

    public GCReplySearchRefitData $sendMessage;

    public function __construct()
    {
        $this->message = new CGSearchRefit();
        $this->sendMessage = new GCReplySearchRefitData();
    }

    public function run(): int
    {
        $uid = $this->message->getUid();
        if ($uid == 0){
            return false;
        }
        $result = $this->searchRefitData($uid);
        $this->sendMessage->setUid((int)$uid);
        $this->sendMessage->setAttr($result['Attr']);
        SendMessage::getInstance()->sendClient(
            PacketId::GC_ReplySearchRefitData, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}