<?php
/**
 * 汽车外观获取
 * @date 2022-5-25
 * @author leeFx
 **/
namespace Game\Controller\Car;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\CarExteriorRefitLogic;
use Game\Protobuf\CGGetCarExteriorRefit;
use Game\Protobuf\GCCarExteriorRefit;
use Game\Protobuf\GCGetCarExteriorRefit;
use Game\Protobuf\PacketId;

class GetExteriorRefit extends ControllerBase
{
    use CarExteriorRefitLogic;

    public GCGetCarExteriorRefit $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetCarExteriorRefit();
        $this->sendMessage = new GCGetCarExteriorRefit();
    }

    public function run(): int
    {
        $carUID = $this->message->getCarUID();
        $tplID = $this->message->getTplID();
        $params = $this->message->getParams();

        if(!$this->createExteriorRefitData($carUID, $tplID, $params)) {
            return false;
        }
        return ErrorDefine::SUCCESS;
    }
}