<?php
/**
 * 汽车外观修改
 * @date 2022-5-25
 * @author leeFx
 **/


namespace Game\Controller\Car;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\CarExteriorRefitLogic;
use Game\Logic\CarLogic;
use Game\Protobuf\CGCarExteriorRefit;
use Game\Protobuf\CGCarExteriorRefitUpdate;
use Game\Protobuf\CGCarRefit;
use Game\Protobuf\GCCarExteriorRefit;
use Game\Protobuf\GCCarExteriorRefitUpdate;
use Game\Protobuf\GCReplyRefitData;
use Game\Protobuf\PacketId;

class ExteriorRefitUpdate extends ControllerBase
{
    use CarExteriorRefitLogic;

    public GCCarExteriorRefitUpdate $sendMessage;

    public function __construct()
    {
        $this->message = new CGCarExteriorRefitUpdate();
        $this->sendMessage = new GCCarExteriorRefitUpdate();
    }

    public function run(): int
    {
        $carUID = $this->message->getCarUID();
        $type = $this->message->getType();
        $refitID = $this->message->getRefitID();
        $params = $this->message->getParams();
        $num = $this->message->getNum();

        if(!$this->exteriorRefitUpdate($carUID, $type, $refitID, $params, $num)) {
            return false;
        }
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setType($type);
        $this->sendMessage->setNum($num);
        $this->sendMessage->setCarUID($carUID);
        $this->sendMessage->setRefitID($refitID);
        SendMessage::getInstance()->sendClient(
            PacketId::GC_CarExteriorRefitUpdate, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}