<?php
/**
 * 外观删除
 * @date 2022-5-25
 * @author leeFx
 **/


namespace Game\Controller\Car;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\CarExteriorRefitLogic;
use Game\Protobuf\CGCarExteriorRefitDel;
use Game\Protobuf\GCCarExteriorRefitDel;
use Game\Protobuf\PacketId;

class ExteriorRefitDel extends ControllerBase
{
    use CarExteriorRefitLogic;

    public GCCarExteriorRefitDel $sendMessage;

    public function __construct()
    {
        $this->message = new CGCarExteriorRefitDel();
        $this->sendMessage = new GCCarExteriorRefitDel();
    }

    public function run(): int
    {
        $carUID = $this->message->getCarUID();
        $type = $this->message->getType();
        $refitID = $this->message->getRefitID();
        $num = $this->message->getNum();

        if(!$this->exteriorRefitDel($carUID, $type, $refitID, $num)) {
            return false;
        }
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setRefitID($refitID);
        $this->sendMessage->setCarUID($carUID);
        $this->sendMessage->setNum($num);
        $this->sendMessage->setType($type);
        SendMessage::getInstance()->sendClient(
            PacketId::GC_CarExteriorRefitDel, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}