<?php
/**
 * 外观车贴增加
 * @date 2022-5-26
 * @author leeFx
 **/


namespace Game\Controller\Car;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\CarExteriorRefitLogic;
use Game\Protobuf\CGAddCarExteriorRefit;
use Game\Protobuf\GCAddCarExteriorRefit;
use Game\Protobuf\PacketId;

class ExteriorRefitAdd extends ControllerBase
{
    use CarExteriorRefitLogic;

    public GCAddCarExteriorRefit $sendMessage;

    public function __construct()
    {
        $this->message = new CGAddCarExteriorRefit();
        $this->sendMessage = new GCAddCarExteriorRefit();
    }

    public function run(): int
    {
        $carUID = $this->message->getCarUID();
        $type = $this->message->getType();
        $refitID = $this->message->getRefitID();
        $params = $this->message->getParams();
        $num = $this->message->getNum();

        if(!$this->addExteriorRefit($carUID, $type, $refitID, $params, $num)) {
            return false;
        }
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setType($type);
        $this->sendMessage->setNum($num);
        $this->sendMessage->setCarUID($carUID);
        $this->sendMessage->setRefitID($refitID);
        SendMessage::getInstance()->sendClient(
            PacketId::GC_AddCarExteriorRefit, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}