<?php
/**
 * 车库信息
 * @date 2022-3-16
 * @author JZW
 **/

namespace Game\Controller\Car;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\CarLogic;
use Game\Protobuf\CGSearchCarport;
use Game\Protobuf\GCReplyCarportData;
use Game\Protobuf\PacketId;

class Carport extends ControllerBase
{
    use CarLogic;

    public GCReplyCarportData $sendMessage;

    public function __construct()
    {
        $this->message = new CGSearchCarport();
        $this->sendMessage = new GCReplyCarportData();
    }

    public function run(): int
    {
        $data = $this->searchPlayerCar();
        $this->sendMessage->setCarList($data);
        SendMessage::getInstance()->sendClient(PacketId::GC_ReplyCarportData, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}