<?php

/**
 * CarReplace.php
 * 更换赛车
 * Created On 2022/03/11
 */

namespace Game\Controller\Car;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\CarLogic;
use Game\Protobuf\CGReplaceCarSend;
use Game\Protobuf\GCReplaceCarRecv;
use Game\Protobuf\PacketId;

class CarReplace extends ControllerBase
{
    use CarLogic;

    private GCReplaceCarRecv $sendMessage;

    public function __construct()
    {
        $this->message = new CGReplaceCarSend();
        $this->sendMessage = new GCReplaceCarRecv();
    }

    public function run(): int
    {
        $uid = $this->message->getUid();
        $code = ClientErrorCode::CLIENT_SUCCESS;
        if ($this->replacePlayerCar($uid, $code)) {
            $this->sendMessage->setSucc(true);
            $this->sendMessage->setUID($uid);
        } else {
            $this->sendMessage->setSucc(false);
        }
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_Car_Replace_Recv, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}