<?php
/**
 * 汽车改装
 * @date 2022-3-22
 * @author JZW
 **/


namespace Game\Controller\Car;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\CarLogic;
use Game\Protobuf\CGCarRefit;
use Game\Protobuf\GCReplyRefitData;
use Game\Protobuf\PacketId;

class CarRefit extends ControllerBase
{
    use CarLogic;

    public GCReplyRefitData $sendMessage;

    public function __construct()
    {
        $this->message = new CGCarRefit();
        $this->sendMessage = new GCReplyRefitData();
    }

    public function run(): int
    {
        $uid = $this->message->getUid();
        if ($uid == 0){
            return false;
        }
        $sys = $this->message->getSys();
        $this->makeRefit($uid, $sys, $result);
        $this->sendMessage->setCode($result['Code']);
        $this->sendMessage->setUid((int)$uid);
        $this->sendMessage->setAttr($result['Attr']);
        SendMessage::getInstance()->sendClient(
            PacketId::GC_ReplyRefitData, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}