<?php
/**
 * 汽车外观改装
 * @date 2022-5-16
 * @author leeFx
 **/

namespace Game\Controller\Car;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\CarExteriorRefitLogic;
use Game\Protobuf\CGCarExteriorRefit;
use Game\Protobuf\GCCarExteriorRefit;

class CarExteriorRefit extends ControllerBase
{
    use CarExteriorRefitLogic;

    public GCCarExteriorRefit $sendMessage;

    public function __construct()
    {
        $this->message = new CGCarExteriorRefit();
        $this->sendMessage = new GCCarExteriorRefit();
    }

    public function run(): int
    {
        $carUID = $this->message->getCarUID();
        $type = $this->message->getType();
        $refitID = $this->message->getRefitID();
        $params = $this->message->getParams();

        if(!$this->carExteriorRefit($carUID, $type, $refitID, $params)) {
            return false;
        }

        return ErrorDefine::SUCCESS;
    }
}