<?php

/**
 * 修改排位赛位置排序
 */

namespace Game\Controller;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Model\PaiweiLevelModel;
use Game\Protobuf\CGUpdatePaiWeiPositionOrder;

class CG_UpdatePaiWeiPositionOrder extends ControllerBase
{
    public function __construct()
    {
        $this->message = new CGUpdatePaiWeiPositionOrder();
    }

    public function run(): int
    {
        /**
         * @var PaiweiLevelModel $levelModel
         */
        $levelModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PAIWEI_LEVEL);
        $positionOrder = [
            $this->message->getPositionOrder1(),
            $this->message->getPositionOrder2(),
            $this->message->getPositionOrder3(),
        ];
        $levelModel->updatePositionOrder($positionOrder);
        return ErrorDefine::SUCCESS;
    }
}
