<?php
namespace Game\Controller\Activity\Welfare;
use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateActivityWelfare;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\EventLogic;
use Game\Model\Activity\WelfareModel;
use Game\Protobuf\CGReceiveLoginReward;
use Game\Protobuf\GCGetLoginRewardData;
use Game\Protobuf\PacketId;
use Framework\Logic\TemplateHelp;
use Game\Logic\ItemLogic;

class ReceiveLoginReward extends ControllerBase
{
    use TemplateHelp;
    use ItemLogic;
    use EventLogic;

    private GCGetLoginRewardData $sendMsg;
    public function __construct()
    {
        $this->message = new CGReceiveLoginReward();
        $this->sendMsg = new GCGetLoginRewardData();
    }

    public function run(): int
    {
        $id = $this->message->getID();
        $tplID = $this->message->getTplID();

        if($tplID % 10 != $id) {
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_PARAMS_FORMAT_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        /**
         * @var WelfareModel $welfareModel
         */
        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
        if(!$welfareModel->data->searchDB()) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'get day login activity data error!'
            );
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_FIND_LOGIN_RECEIVE_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        // 判断是否已经完成
        if(!in_array($id, $welfareModel->data->loginRecord1)) {
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_LOGIN_RECEIVE_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        // 判断是否已经领取
        if(in_array($id, $welfareModel->data->loginRecord2)) {
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_LOGIN_RECEIVE_REPEATED_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        // 领取奖励
        if(!$this->receiveItem($tplID)) {
            return ErrorDefine::SUCCESS;
        }
        // 保存
        $welfareModel->data->loginRecord2[] = $id;
        $welfareModel->data->updateDB();
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setRecord1($welfareModel->data->loginRecord1);
        $this->sendMsg->setRecord2($welfareModel->data->loginRecord2);
        //触发任务
        $eventData = array(
            GameConstantDefine::EVENT_KEY_NUM => 1,
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_SUPPLY, $eventData);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }

    private function receiveItem(int $tplID): bool {
        $cfg = $this->getTitle(TemplateDefine::TYPE_ACTIVITY_WELFARE, $tplID);
        if(is_null($cfg)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'receive reward login reward activity cfg data error!'
            );
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_FIND_LOGIN_REWARD_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
            return false;
        }
        $itemArr = [];
        if(!empty($cfg[TemplateActivityWelfare::ItemId1])) {
            $itemArr[$cfg[TemplateActivityWelfare::ItemId1]] = $cfg[TemplateActivityWelfare::Numb1];
        }
        if(!empty($cfg[TemplateActivityWelfare::ItemId2])) {
            isset($itemArr[$cfg[TemplateActivityWelfare::ItemId2]]) ?
                $itemArr[$cfg[TemplateActivityWelfare::ItemId2]] += $cfg[TemplateActivityWelfare::Numb2]
                : $itemArr[$cfg[TemplateActivityWelfare::ItemId2]] = $cfg[TemplateActivityWelfare::Numb2];
        }
        if(!empty($itemArr)) {
            $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_LOGIN_REWARD);
            if(!$this->gainItemArr($itemArr)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::DATA_UPDATE_ERROR,
                    'receive reward gain item error!'
                );
                $this->sendMsg->setCode(ClientErrorCode::WELFARE_FIND_LOGIN_REWARD_ERROR);
                SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
                return false;
            }
        }
        return true;
    }

}