<?php
namespace Game\Controller\Activity\Welfare;
use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateActivityWelfare;
use Game\Constant\GameConstantDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\AccountData;
use Game\Logic\MoneyLogic;
use Game\Model\Activity\WelfareModel;
use Game\Protobuf\CGReceive7NewReward;
use Game\Protobuf\GCReceive7NewReward;
use Game\Protobuf\PacketId;
use Game\Logic\AccountLogic;

class Receive7New extends ControllerBase
{
    use AccountLogic;
    private GCReceive7NewReward $sendMsg;
    public function __construct()
    {
        $this->message = new CGReceive7NewReward();
        $this->sendMsg = new GCReceive7NewReward();
    }

    public function run(): int
    {
        $id = $this->message->getID();
        $tplID = $this->message->getTplID();
        if($tplID % 10 != $id) {
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_PARAMS_FORMAT_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_Receive7NewReward, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        // 判断是否在时间内领取
        if(!$this->verifyReceiveTime()) {
            return ErrorDefine::SUCCESS;
        }
        /**
         * @var WelfareModel $welfareModel
         */
        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
        if(!$welfareModel->data->searchDB()) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'receive reward get 7 new activity data error!'
            );
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_FIND_7NEW_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_Receive7NewReward, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        if(in_array($id, $welfareModel->data->newRecord)) {
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_7NEW_NOT_REPEATED_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_Receive7NewReward, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        // 领取奖励
        if(!$this->receiveItem($tplID)) {
            return ErrorDefine::SUCCESS;
        }
        // 保存返回
        $welfareModel->data->newRecord[] = $id;
        $welfareModel->updateWelfare();
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setRecord($welfareModel->data->newRecord);
        SendMessage::getInstance()->sendClient(PacketId::GC_Receive7NewReward, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }

    private function verifyReceiveTime():bool {
        /**
         * @var WelfareModel $welfareModel
         */
        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
        $createTime = $this->getAccountAttribute(AccountData::DB_CREATE_TIME);
        if(empty($createTime)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'receive reward get account ctime error!'
            );
            return false;
        }
        if($createTime + $welfareModel::ACTIVITY_7NEW_TIME_LIMIT < Utils::getServerTimestamp()) {
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_RECEIVE_TIMEOUT_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_Receive7NewReward, $this->sendMsg);
            return false;
        }
        return true;
    }

    private function receiveItem(int $tplID): bool {
        $cfg = $this->getTitle(TemplateDefine::TYPE_ACTIVITY_WELFARE, $tplID);
        if(is_null($cfg)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'receive reward get 7 new activity cfg data error!'
            );
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_FIND_7NEW_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_Receive7NewReward, $this->sendMsg);
            return false;
        }
        $itemArr = [];
        if(!empty($cfg[TemplateActivityWelfare::ItemId1])) {
            $itemArr[$cfg[TemplateActivityWelfare::ItemId1]] = $cfg[TemplateActivityWelfare::Numb1];
        }
        if(!empty($cfg[TemplateActivityWelfare::ItemId2])) {
            isset($itemArr[$cfg[TemplateActivityWelfare::ItemId2]]) ?
                $itemArr[$cfg[TemplateActivityWelfare::ItemId2]] += $cfg[TemplateActivityWelfare::Numb2]
                : $itemArr[$cfg[TemplateActivityWelfare::ItemId2]] = $cfg[TemplateActivityWelfare::Numb2];
        }
        if(!empty($itemArr)) {
            $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_7_DAY_REWARD);
            if(!$this->gainItemArr($itemArr)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::DATA_UPDATE_ERROR,
                    'receive reward gain item error!'
                );
                $this->sendMsg->setCode(ClientErrorCode::WELFARE_FIND_7NEW_ERROR);
                SendMessage::getInstance()->sendClient(PacketId::GC_Receive7NewReward, $this->sendMsg);
                return false;
            }
        }
        return true;
    }
}