<?php
namespace Game\Controller\Activity\Welfare;
use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Model\Activity\WelfareModel;
use Game\Protobuf\CGGetWeekLoginInfo;
use Game\Protobuf\GCGetWeekInfo;
use Game\Protobuf\PacketId;

class GetWeekLoginInfo extends ControllerBase
{
    private GCGetWeekInfo $sendMsg;
    public function __construct()
    {
        $this->message = new CGGetWeekLoginInfo();
        $this->sendMsg = new GCGetWeekInfo();
    }

    public function run(): int
    {
        /**
         * @var WelfareModel $welfareModel
         */
        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
        if(!$welfareModel->data->searchDB()) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'get week login info activity data error!'
            );
            $this->sendMsg->setCode(ClientErrorCode::ACTIVITY_WEEK_LOGIN_GET_INFO_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetWeekLoginInfo, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setState($welfareModel->data->weekLoginState);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetWeekLoginInfo, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }
}