<?php
namespace Game\Controller\Activity\Welfare;
use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Model\Activity\WelfareModel;
use Game\Protobuf\CGGetLoginRewardData;
use Game\Protobuf\GCGetLoginRewardData;
use Game\Protobuf\PacketId;

class GetLoginReward extends ControllerBase
{
    private GCGetLoginRewardData $sendMsg;
    public function __construct()
    {
        $this->message = new CGGetLoginRewardData();
        $this->sendMsg = new GCGetLoginRewardData();
    }

    public function run(): int
    {
        /**
         * @var WelfareModel $welfareModel
         */
        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
        if(!$welfareModel->data->searchDB()) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'get login reward activity data error!'
            );
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_FIND_LOGIN_REWARD_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setRecord1($welfareModel->data->loginRecord1);
        $this->sendMsg->setRecord2($welfareModel->data->loginRecord2);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetLoginRewardData, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }
}