<?php
namespace Game\Controller\Activity\Welfare;
use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Model\Activity\WelfareModel;
use Game\Protobuf\CGGet7NewData;
use Game\Protobuf\GCGet7NewData;
use Game\Protobuf\PacketId;

class Get7NewData extends ControllerBase
{
    private GCGet7NewData $sendMsg;
    public function __construct()
    {
        $this->message = new CGGet7NewData();
        $this->sendMsg = new GCGet7NewData();
    }

    public function run(): int
    {
        /**
         * @var WelfareModel $welfareModel
         */
        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
        if(!$welfareModel->data->searchDB()) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'get 7 new activity data error!'
            );
            $this->sendMsg->setCode(ClientErrorCode::WELFARE_FIND_7NEW_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_Receive7NewReward, $this->sendMsg);
            return ErrorDefine::SUCCESS;
        }
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setNum($welfareModel->data->newNumber);
        $this->sendMsg->setRecord($welfareModel->data->newRecord);
        SendMessage::getInstance()->sendClient(PacketId::GC_Get7NewData, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }
}