<?php
namespace Game\Controller\Activity\Welfare;
use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateActivityWelfare;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\TaskData;
use Game\Logic\Task\TaskLogic;
use Game\Model\Activity\WelfareModel;
use Game\Protobuf\CGAgainWeekTask;
use Game\Protobuf\GCAgainWeekTask;
use Game\Protobuf\GCSubmitTaskReset;
use Game\Protobuf\PacketId;
use Framework\Logic\TemplateHelp;
use Game\Logic\ItemLogic;

class AgainWeekTask extends ControllerBase
{
    use TemplateHelp;
    use ItemLogic;
    use TaskLogic;
    private GCAgainWeekTask $sendMsg;
    public function __construct()
    {
        $this->message = new CGAgainWeekTask();
        $this->sendMsg = new GCAgainWeekTask();
    }

    public function run(): int
    {
        $week = $this->message->getWeek();
        $taskId = $this->message->getTaskID();

        //判断礼品券是否充足
        $id = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Again_Task_Item_ID, "Const_num");
        // 解散房间提醒倒计时
        $num = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Again_Task_Item_NUM, "Const_num");

        $itemNum = $this->getMoneyNum($id);
        if($num > $itemNum) {
            return $this->sendClientMessage(ClientErrorCode::ERROR_AGAIN_TASK_ITEM_NUM_NOT_ENOUGH);
        }

        $this->subMoney($id, $num);
        //检查任务
        $code = $this->checkTaskExist($taskId);
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            return $this->sendClientMessage($code);
        }
        /**
         * @var TaskData $taskData
         */
        $taskData = $this->searchTask($taskId);
        if (is_null($taskData)) {
            return $this->sendClientMessage(ClientErrorCode::TASK_NOT_FOUND);
        }
        // 已完成不需要补签
        if ($taskData->status == TaskData::STATUS_OVER) {
            return $this->sendClientMessage(ClientErrorCode::TASK_IS_OVER);
        }
        $cfg = $this->getTitle(TemplateDefine::TYPE_TASK, $taskId);
        $taskData->schedule = $cfg[TemplateTask::Target];

        // 提交任务
        $this->submitTask($taskData);

        // 判断当天是否已经登录 如果没有登录则做周六日登录任务触发
        $this->verifyTriggerTask($week);

        $this->sendMsg->setWeek($week);
        $this->sendClientMessage(ClientErrorCode::CLIENT_SUCCESS);

        // 返回task提交完成消息
        $msg = new GCSubmitTaskReset();
        $msg->setCode($code);
        $msg->setTaskId($this->message->getTaskId());
        SendMessage::getInstance()->sendClient(PacketId::GC_SubmitTaskReset, $msg);
        return ErrorDefine::SUCCESS;
    }
    private function verifyTriggerTask(int $week) {
        /**
         * @var WelfareModel $welfareModel
         */
        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
        if(!$welfareModel->data->searchDB()) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                'get again week login activity data error!'
            );
            return ;
        }
        // 判断是否已经完成
        if(in_array($week, $welfareModel->data->weekRecord)) {
            return ;
        }
        // 加入到登录周记录
        $welfareModel->data->weekRecord[] = $week;
        $welfareModel->data->updateDB();
    }

    private function sendClientMessage(int $code): int
    {
        $this->sendMsg->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_AgainWeekTask, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }

}