<?php

/**
 * 处理换车请求
 */

namespace Game\Controller\Activity\Scuffle;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Activity\ScuffleLogic;
use Game\Protobuf\CGDealScuffleReplaceCarApply;
use Game\Protobuf\GCDealScuffleReplaceCarApply;
use Game\Protobuf\PacketId;

class CG_DealScuffleReplaceCarApply extends ControllerBase
{
    use ScuffleLogic;

    private GCDealScuffleReplaceCarApply $sendMessage;

    public function __construct()
    {
        $this->message = new CGDealScuffleReplaceCarApply();
        $this->sendMessage = new GCDealScuffleReplaceCarApply();
    }

    public function run(): int
    {
        $this->sendMessage->setCode($this->dealReplaceCarApply(
            $this->message->getOption(),
            $this->message->getApplyPlayerId(),
            $this->playerId
        ));
        $this->sendMessage->setApplyPlayerId($this->message->getApplyPlayerId());
        SendMessage::getInstance()->sendClient(PacketId::GC_DealScuffleReplaceCarApply, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
