<?php

/**
 * 取消交换赛车
 */

namespace Game\Controller\Activity\Scuffle;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Activity\ScuffleLogic;
use Game\Protobuf\CGCancelReplaceCar;
use Game\Protobuf\GCCancelReplaceCar;
use Game\Protobuf\PacketId;

class CG_CancelReplaceCar extends ControllerBase
{
    use ScuffleLogic;

    private GCCancelReplaceCar $sendMessage;

    public function __construct()
    {
        $this->message = new CGCancelReplaceCar();
        $this->sendMessage = new GCCancelReplaceCar();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->cancelReplaceCar(
                $this->message->getTargetPlayerId(),
                $this->playerId)
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_CancelReplaceCar, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
