<?php

/**
 * 发送交换赛车请求
 */

namespace Game\Controller\Activity\Scuffle;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Activity\ScuffleLogic;
use Game\Protobuf\CGApplyScuffleReplaceTargetCar;
use Game\Protobuf\GCApplyScuffleReplaceTargetCar;
use Game\Protobuf\PacketId;

class CG_ApplyScuffleReplaceTargetCar extends ControllerBase
{
    use ScuffleLogic;

    private GCApplyScuffleReplaceTargetCar $sendMessage;

    public function __construct()
    {
        $this->message = new CGApplyScuffleReplaceTargetCar();
        $this->sendMessage = new GCApplyScuffleReplaceTargetCar();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->applyReplaceTargetCar(
                $this->message->getTargetPlayerId(),
                $this->playerId
            )
        );
        $this->sendMessage->setTargetPlayerId($this->message->getTargetPlayerId());
        SendMessage::getInstance()->sendClient(PacketId::GC_ApplyScuffleReplaceTargetCar, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
