<?php

/**
 * 获取地图挑战赛自己排名
 */

namespace Game\Controller\Activity\MapChallenge;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\RankLogic;
use Game\Protobuf\CGMpaChallengeRank;
use Game\Protobuf\GCMpaChallengeRank;
use Game\Protobuf\PacketId;

class CG_MpaChallengeRank extends ControllerBase
{
    use RankLogic;

    private GCMpaChallengeRank $sendMessage;

    public function __construct()
    {
        $this->message = new CGMpaChallengeRank();
        $this->sendMessage = new GCMpaChallengeRank();
    }

    public function run(): int
    {
        $this->sendMessage->setRank($this->getMapChallengeRank($this->message->getMapId()));
        SendMessage::getInstance()->sendClient(PacketId::GC_MpaChallengeRank, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
